<?php
class ControllerExtensionModuleFeatured extends Controller {
	public function index($setting) {
		$this->load->language('extension/module/featured');

		$this->load->model('catalog/product');

		$this->load->model('tool/image');

		$data['results'] = array();

		if (!$setting['limit']) {
			$setting['limit'] = 4;
		}

		if (!empty($setting['product'])) {
			$results = array_slice($setting['product'], 0, (int)$setting['limit']);

			foreach ($results as $product_id) {
				$result = $this->model_catalog_product->getProduct($product_id);

				if ($result) {
					if ($result['image']) {
						$image = $this->model_tool_image->resize($result['image'], $setting['width'], $setting['height']);
					} else {
						$image = $this->model_tool_image->resize('placeholder.png', $setting['width'], $setting['height']);
					}

					if ($this->customer->isLogged() || !$this->config->get('config_customer_price')) {
						$price = $this->currency->format($this->tax->calculate($result['price'], $result['tax_class_id'], $this->config->get('config_tax')), $this->session->data['currency']);
					} else {
						$price = false;
					}

					if (!is_null($result['special']) && (float)$result['special'] >= 0) {
						$special = $this->currency->format($this->tax->calculate($result['special'], $result['tax_class_id'], $this->config->get('config_tax')), $this->session->data['currency']);
						$special_percent = round(100-($result['special']/($result['price']/100)));
						$tax_price = (float)$result['special'];
					} else {
						$special = false;
						$special_percent = false;
						$tax_price = (float)$result['price'];
					}
		
					if ($this->config->get('config_tax')) {
						$tax = $this->currency->format($tax_price, $this->session->data['currency']);
					} else {
						$tax = false;
					}

					if ($this->config->get('config_review_status')) {
						$rating = $result['rating'];
					} else {
						$rating = false;
					}

					if ($result['quantity'] <= 0 or $result['stock_status_id'] != 7) {
						$stock = $result['stock_status'];
						$out_of_stock = true;
					} elseif ($this->config->get('config_stock_display')) {
						$stock = $result['quantity'];
						$out_of_stock = true;
					} else {
						$stock = $result['stock_status'];
						$out_of_stock = false;
					}

					// dc_template_pro

					$data['products'][] = array(
						'product_id'  => $result['product_id'],
						'thumb'       => $image,
						'name'        => $result['name'],
						'description' => utf8_substr(strip_tags(html_entity_decode($result['description'], ENT_QUOTES, 'UTF-8')), 0, $this->config->get('theme_' . $this->config->get('config_theme') . '_product_description_length')) . '..',
						'price'       => $price,
						'special'     => $special,
						'special_percent'     => $special_percent,
						'tax'         => $tax,
						'stock_status_id' 	  => $result['stock_status_id'],
						'stock' 	  => $stock,
						'out_of_stock' 	  => $out_of_stock,
						'rating'      => $rating,
						'href'        => $this->url->link('product/product', 'product_id=' . $result['product_id'])
					);
				}
			}
		}

		if ($data['products']) {
			return $this->load->view('extension/module/featured', $data);
		}
	}
}